<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CServices extends CPlugin{
	
	var $tplvars; 

	var $media = array(
		"hide"	=> array(
			"list"	=> array(
				"item_show",
			),
			"edit"	=> array(
				"item_show",
			)
		),

		"tn"	=> array(
			"width"		=> "720",
			"height"	=> ""
		),

		"tn2"	=> array(
			"width"		=> "720",
			"height"	=> "406"
		),


		"path"	=> "./services/"

	);

	function __construct() {
		$this->name = "services";
	}


	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;



		if ($_GET["mod"] == $this->name) {
			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];

			switch ($sub) {


				case "landing":
					$_GET["sub"] = $sub = "cats";
				case "cats":

					//media compatibility fix
					$_GET["item_id"] = $_GET["cat_id"];

					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);

					$this->PrepareFields($data->forms["forms"]);

					$data->functions = array( 
							"ondelete" => array(&$this , "DeleteCat"),
					);					
					
					return $data->DoEvents();
				break;


				case "texts":
					return $this->__adminTexts();
				break;


			}
		}
	}




	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onDelete($module_data) {

		$tables  = array(
			"plugin:services_cats" , 
			"plugin:services_cats_lang",
		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}
	

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DeleteCat($record) {

		//delete images languages
		$this->db->Query("
			DELETE FROM {$this->tables['plugin:media_lang']}
			WHERE 
				item_id in ( 
					SELECT item_id FROM {$this->tables['plugin:media']} 
					WHERE 
						item_parent = {$record[cat_id]} AND 
						module_id = {$record[module_id]}
				);
		"
		);

		//delete images
		$this->db->Query("
			DELETE FROM {$this->tables['plugin:media']}
			WHERE
				item_parent = {$record[cat_id]} AND 
				module_id = {$record[module_id]}
		");

	}


	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {		

		$wid = $this->plugins["widgets"]->AddWidget(array(
			"type"			=> "cserviceswidgetmenu",
			"type_name"		=> "Side Menu",
			"title"			=> "Categories",
			"note"			=> "Auto-Generated",
			"settings"		=> array( "set_style"	=> "2"),
			"module"		=> $module_data["mod_id"],
		));

		$layout = $this->plugins["layouts"]->SaveLayout(
			array(
				"name"			=> $module_data["mod_name"] . " - Details",
				"block"			=> array(
					"col"	=> array(

						0 => array("size"	=> 3 , "widget"	=> $wid),
						1 => array("size"	=> 9 , "widget"	=> array( "__CONTENT__"  , $this->plugins["comments"]->GetCommentsWidget())),					
					)
				)				
			)
		);

		//update the layout id
		$this->plugins["modules"]->UpdateModuleSettings(
			$module_data["mod_id"] , 
			array(
				"set_layout_details"			=> $layout,
			)
		);

		$this->CreatePageTitleBlock(array(
			"module_id"	=> $module_data["mod_id"],
			"title"		=> $module_data["mod_name"],
			"subtitle"	=> "You can edit this section in the Module Head tab",
			"show"		=> 1,
		));

	}


}

?>